#ifdef _VERSION_CHECK_
	#ifndef MSET

		#ifndef _NOT_INSTANCED_
		
			#version 120
			#extension EXT_gpu_shader4 : enable          
		
		#endif
			
	#endif
#endif

#ifdef SKINNING

	//uniform mat4 	boneMatrices[100];
			
		uniform samplerBuffer 	boneMatrices;
	
	//attribute vec4  weights;
	//attribute vec4  matrixIndices;

#endif

#ifndef _NOT_INSTANCED_
	uniform samplerBuffer 			WorldPoses;
#endif

varying vec2 			texcoord;
uniform vec2			tscale;
uniform vec2			tofs;
varying vec2			alphacoords;
//uniform mat4	WTM;
uniform float 	fade;
uniform float 	alpha;
varying float	fadeAlpha;
uniform vec4	colorMod;	// a = decal life

vec2 ComputeFrame(float dt, vec2 nf)
{
	vec2 ofs=vec2(1.0,1.0)/nf;
	float frame=floor(dt*nf.x*nf.y);
	float row=floor(frame/nf.x);
	float col=floor(frame-nf.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

void main()
{
#ifdef SKINNING

	vec4 index  		= gl_SecondaryColor;//matrixIndices;
	vec4 weight 		= gl_Color;//weights;
	vec4 position   	= vec4( 0.0, 0.0, 0.0, 0.0 );
	mat4 TM;

	int j;
  	for( int i = 0; i < 4; i++ )
 	{
	
				j=int(index[i])*4;
				TM[0]=texelFetchBuffer(boneMatrices,j);
				TM[1]=texelFetchBuffer(boneMatrices,j+1);
				TM[2]=texelFetchBuffer(boneMatrices,j+2);
				TM[3]=texelFetchBuffer(boneMatrices,j+3);
				
				position = position + (TM * gl_Vertex) *weight[i];
			
			
 	    // Apply influence of bone i
	//	TM=boneMatrices[int(index[i])];
    	//position = position + (TM * gl_Vertex) *weight[i];
	}
	gl_Position = gl_ModelViewProjectionMatrix * position;

#else

	#ifndef _NOT_INSTANCED_
		mat4 MTX;
		int index=gl_InstanceID*4;
		MTX[0]=texelFetchBuffer(WorldPoses,index);
		MTX[1]=texelFetchBuffer(WorldPoses,index+1);
		MTX[2]=texelFetchBuffer(WorldPoses,index+2);
		MTX[3]=texelFetchBuffer(WorldPoses,index+3);
		fadeAlpha=MTX[3].w;
		MTX[3].w=1.0;
		
		gl_Position = (gl_ModelViewProjectionMatrix*MTX)*gl_Vertex;//ftransform();
		
		MTX=gl_ModelViewMatrix*MTX;
		vec4 pos=MTX*gl_Vertex;
		float dist=(length(pos.xyz)-fadeAlpha*0.8)/(fadeAlpha*0.2);//*0.8);
		fadeAlpha=(1.0 - (clamp(dist,0.0,1.0)))*alpha*colorMod.a;
		
	#else
		gl_Position = (gl_ModelViewProjectionMatrix)*gl_Vertex;//ftransform();
		
		vec4 pos=gl_ModelViewMatrix*gl_Vertex;
		float dist=(length(pos.xyz)-fade*0.8)/(fade*0.2);//*0.8);
		fadeAlpha=(1.0 - (clamp(dist,0.0,1.0)))*alpha*colorMod.a;
	#endif

#endif
			
	texcoord = gl_MultiTexCoord0.st*tscale+tofs;	
	alphacoords = gl_MultiTexCoord0.st;
}